﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Linq;
using UnityEngine;

public class TimeTrialConfiguration : ConfigurationElement
{
    public Vector2 DestinationIconRenderSize { get; private set; }
    public TimeTrialEasyConfiguration Easy { get; private set; }
    public TimeTrialMediumConfiguration Medium { get; private set; }
    public TimeTrialHardConfiguration Hard { get; private set; }

    public TimeTrialConfiguration() : base("TimeTrial")
    {

    }

    public override bool Parse(XElement configElem)
    {
        try
        {
            DestinationIconRenderSize = configElem.Element("DestinationIconRenderSize").Value.ToVector2();

            //Create our sub-configuration objects
            Easy = new TimeTrialEasyConfiguration();
            Medium = new TimeTrialMediumConfiguration();
            Hard = new TimeTrialHardConfiguration();

            //Let's try to parse all of our sub configurations, passing in the corresponding parent elements
            if (Easy.Parse(configElem.Element("Easy")))
            {
                if (Medium.Parse(configElem.Element("Medium")))
                {
                    if (Hard.Parse(configElem.Element("Hard")))
                    {
                        return true;    //Parsed everything successfully!
                    }

                    else
                    {
                        Debug.LogError("ERROR: Failed to parse time trial hard configuration.");
                    }
                }

                else
                {
                    Debug.LogError("ERROR: Failed to parse time trial medium configuration.");
                }
            }

            else
            {
                Debug.LogError("ERROR: Failed to parse time trial easy configuration.");
            }

            return false;   //We must have failed to parse one of the configurations
        }

        catch (Exception ex)
        {
            Debug.LogError("ERROR: Caught an exception when parsing time trial configuration. The exception is: " + ex);
            Preloader.ExceptionMessage = ex.ToString();
            return false;
        }
    }
}
